<?php
/*
	Stempora web framework
	copyright (c) 2002-2016 Stempora
		web:  www.stempora.com
		mail: support@stempora.com

*/

// dependencies


/**
* description
*
* @library	
* @author	
* @since	
*/
class ChtmlElements{
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __construct() {

		$templates = array(
			"widget"		=> "templates/widget.htm",
			"table"			=> "templates/table.htm",
			"charts"		=> "templates/charts.htm",
			"messages"		=> "templates/messages.htm",
		);

		if (is_array($templates)) {
			foreach ($templates as $key => $val) {

				$this->templates[$key] = new CTemplateDynamic($val);
			}			
		}
		
	}

	/**
	* description
	*
	* @param data = array (
			skin	=> "green | pink , etc ..."
			title	=> string, 
			buttons => array(
				"button"	=> array (
					"type" => "button|submit",
					"icon",
					"title",
					"handlers",
					"colors"
				), 
				"button"	=> array(
					"type"	=> "menu",
					"icon"	=> "x",
					"title"	=> ,
					links = array(
						array("icon", title , handlers , color),
						array("icon", title , handlers , color),
						array("icon", title , handlers , color),
					)
				)
			)
		);
		
	*
	* @return
	*
	* @access
	*/
	function Widget($data) {
		global $base;


		if (is_array($data["title"])) {

			foreach ($data["title"]["options"] as $key => $val) {

				$val["icon"] = $val["icon"] ? $this->templates["widget"]->blockReplace("TitleMenuIcon" , $val) : "";

				if ($val["active"]) {
					$title = $val;
					$data["title"]["options"][$key]["active"] = "";//$this->templates->blockReplace("TitleMenuActive");

					//unset($forms["title"]["options"][$key]);
				} else {
					$data["title"]["options"][$key]["active"] = "";
				}

				$data["title"]["options"][$key]["icon"] = $val["icon"];
			}
			

			$_title = $this->templates["widget"]->blockReplace(
				"TitleMenu" ,
				array(
					"items"	=> $base->html->table(
						$this->templates["widget"] , 
						"TitleMenu",
						$data["title"]["options"]
					),				
					
					"subtitle"	=> $title["title"],

					"icon"		=> $title["icon"],

					"details"	=> $data["title"]["subtitle"] ? $this->templates["widget"]->blockreplace("TitleMenuSubtitle" , array("subtitle" => $data["title"]["subtitle"])) : "",
				)
			);

			
		} else {
			$_title = $this->templates["widget"]->blockReplace(
				"TitleText",
				array(					
					"title"	=> $data["title"]
				)
			);
		}
		

		return $this->templates["widget"]->blockReplace(
			"Widget",
			array(
				"title"			=> $_title,
				"icon"			=> $data["icon"] ? $this->templates["widget"]->blockReplace("Icon" , array("icon" => $data["icon"])) : "",
				"skin"			=> $data["skin"],
				"buttons"		=> $this->WidgetButtons($data["buttons"]),
				"id"			=> $data["id"] ? $data["id"] : uniqid(),

				"body"			=> $data["height"] ? 
						$this->templates["widget"]->blockReplace(
							"Content" , 
							array( 
								"body" => $data["content"] , 
								"height" => $data["height"] , 
								"id" => $data["id"] ? $data["id"] : uniqid()
							)
						) : $data["content"],
			)
		);

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function WidgetButtons($buttons) {

		global $base;

		if (is_array($buttons) && count($buttons)) {

			foreach ($buttons as $key => $button) {
				switch ($button["type"]) {
					case "menu":

						$tmp = array();

						if (is_array($button)) {
							foreach ($button["link"] as $k => $val) {
								$tmp[$k] = array(
									"onclick"	=> $val["onclick"],
									"target"	=> $val["target"],
									"icon"		=> $val["icon"] ? $this->templates["widget"]->BlockReplace("Icon" , $val) : "",
									"title"		=> $val["title"],
									"link"		=> $val["location"],
								);
							}								

							$buttons[$key]["menu"] = CTemplateStatic::Replace(
								$base->html->Table(
									$this->templates["widget"] , 
									"HeaderDrop",
									$tmp
								),
								array(
									"key"	=> $key
								)
							);

							$buttons[$key]["toggle"] = $this->templates["widget"]->blockReplaceSingle("HeaderDrop" , "key" , $key);
						}

						$buttons[$key]["onclick"] = $button["onclick"];
						$buttons[$key]["target"] = $button["target"];
						$buttons[$key]["icon"] = $button["icon"] ? $this->templates["widget"]->BlockReplace("Icon" , $button) : "";
						$buttons[$key]["title"] = $button["title"];
						$buttons[$key]["link"] = "#";
					break;
						
					default:

						$buttons[$key] = array(
							"onclick"	=> $button["onclick"],
							"target"	=> $button["target"],
							"icon"		=> $button["icon"] ? $this->templates["widget"]->BlockReplace("Icon" , $button) : "",
							"title"		=> $button["title"],
							"link"		=> $button["location"],
							"menu"		=> "",
							"toggle"	=> "",
						);
					break;

				}
			}
			
			return $this->templates["widget"]->blockReplace(
				"HeaderButtons" , 
				array(
					"buttons"	=> $base->html->Table(
						$this->templates["widget"] , 
						"HeaderButtons" , 
						$buttons
					)
				)
			);
		}

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Alert($type , $size , $title , $subtitle = "") {

		return $this->templates["messages"]->blockReplace(
			$size == "big" ? "Big" : "Small", 
			array(
				"type"		=> $this->templates["messages"]->blockReplace($type , array()),
				"subtitle"	=> $subtitle ? $this->templates["messages"]->blockReplace("Subtitle" , array("subtitle" => $subtitle)) : "",
				"title"		=> $this->templates["messages"]->blockReplace($subtitle ? "Title" : "TitleBig", array("title" => $title)),
			)
		);

	}

	
	function AlertBig($type , $title  ,$subtitle = "") {
		return $this->Alert(
			$type , 
			"big" , 
			$title,
			$subtitle			
		);
	}

	function AlertSmall($type , $title  ,$subtitle = "") {
		return $this->Alert(
			$type , 
			"small" , 
			$title,
			$subtitle			
		);
	}
	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PieChart($id , $data , $options = array()) {

		return CTemplateStatic::Replace(
			$this->templates["charts"]->blockReplace(
				"Pie" , 
				array(
					"chart_id"	=> $id,
					"series"	=> json_encode($data),
				)
			),
			$this->__pieOptions($options)
		);
	}

	function GraphChart($id , $data , $options = array()) {

		return CTemplateStatic::Replace(
			$this->templates["charts"]->blockReplace(
				"Graph" , 
				array(
					"chart_id"	=> $id,
					"series"	=> json_encode($data),
				)
			),
			$this->__pieOptions($options)
		);
	}

	function BarsChart($id , $data , $options = array()) {

		return CTemplateStatic::Replace(
			$this->templates["charts"]->blockReplace(
				"Bars" , 
				array(
					"chart_id"	=> $id,
					"series"	=> json_encode($data),
				)
			),
			$this->__pieOptions($options)
		);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __pieOptions($options) {

		$default = array(
			"bar_width"	=> "0.6",


			"x_mode"	=> "",
			"x_prefix"	=> "",
			"x_sufix"	=> "",

			"y_mode"	=> "",
			"y_prefix"	=> "",
			"y_sufix"	=> "",			

			"width"		=> "100%",
			"height"	=> "200px",


			"x_ticks"	=> "",

		);


		$data = array_merge(
			$default , 
			$options
		);

		return $data;
	}
	
	
}



?>